#!/bin/ksh -p

#
# This file and its contents are supplied under the terms of the
# Common Development and Distribution License ("CDDL"), version 1.0.
# You may only use this file in accordance with the terms of version
# 1.0 of the CDDL.
#
# A full copy of the text of the CDDL should have accompanied this
# source.  A copy of the CDDL is also available via the Internet at
# http://www.illumos.org/license/CDDL.
#

#
# Copyright (c) 2015 by Delphix. All rights reserved.
#

. $STF_SUITE/tests/functional/rsend/rsend.kshlib

#
# Description:
# Verify resumability of full and incremental ZFS send/receive with the -c
# (compress) flag in the presence of a corrupted stream.
#
# Strategy:
# 1. Start a full ZFS send with the -c flag (compress), redirect output to
#    a file
# 2. Mess up the contents of the stream state file on disk
# 3. Try ZFS receive, which should fail with a checksum mismatch error
# 4. ZFS send to the stream state file again using the receive_resume_token
# 5. ZFS receieve and verify the receive completes successfully
# 6. Repeat steps on an incremental ZFS send
#

verify_runnable "both"

sendfs=$POOL/sendfs
recvfs=$POOL2/recvfs
streamfs=$POOL/stream

log_assert "Verify compressed send streams can be resumed if interrupted"
log_onexit resume_cleanup $sendfs $streamfs

test_fs_setup $sendfs $recvfs
resume_test "zfs send -c -v $sendfs@a" $streamfs $recvfs
resume_test "zfs send -c -v -i @a $sendfs@b" $streamfs $recvfs
file_check $sendfs $recvfs

log_pass "Compressed send streams can be resumed if interrupted"
