#!/bin/ksh -p
#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#

#
# Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# Copyright (c) 2013, 2016 by Delphix. All rights reserved.
# Copyright (c) 2018 George Melikov. All Rights Reserved.
#

. $STF_SUITE/include/libtest.shlib
. $STF_SUITE/tests/functional/delegate/delegate_common.kshlib

cleanup_user_group

if ! is_linux; then
	# restore the state of svc:/network/nis/client:default
	if [[ -e $NISSTAFILE ]]; then
		log_must svcadm enable svc:/network/nis/client:default
		log_must rm -f $NISSTAFILE
	fi
fi

if is_freebsd; then
	log_must sysctl vfs.usermount=0
fi

if is_linux; then
	log_must set_tunable64 zfs_admin_snapshot 0
fi

default_cleanup
