/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved.
 * Copyright (c) 2011, 2019 by Delphix. All rights reserved.
 * Copyright 2015 Nexenta Systems, Inc.  All rights reserved.
 * Copyright (c) 2014 Spectra Logic Corporation, All rights reserved.
 * Copyright 2013 Saso Kiselkov. All rights reserved.
 * Copyright (c) 2017 Datto Inc.
 * Copyright (c) 2017, Intel Corporation.
 */

#include <sys/zfs_context.h>
#include <sys/spa_impl.h>
#include <sys/spa.h>
#include <sys/txg.h>
#include <sys/unique.h>
#include <sys/dsl_pool.h>
#include <sys/dsl_dir.h>
#include <sys/dsl_prop.h>
#include <sys/fm/util.h>
#include <sys/dsl_scan.h>
#include <sys/fs/zfs.h>
#include <sys/kstat.h>
#include "zfs_prop.h"

int
param_set_deadman_ziotime(const char *val, zfs_kernel_param_t *kp)
{
	spa_t *spa = NULL;
	int error;

	error = param_set_ulong(val, kp);
	if (error < 0)
		return (SET_ERROR(error));

	if (spa_mode_global != 0) {
		mutex_enter(&spa_namespace_lock);
		while ((spa = spa_next(spa)) != NULL)
			spa->spa_deadman_ziotime =
			    MSEC2NSEC(zfs_deadman_ziotime_ms);
		mutex_exit(&spa_namespace_lock);
	}

	return (0);
}

int
param_set_deadman_synctime(const char *val, zfs_kernel_param_t *kp)
{
	spa_t *spa = NULL;
	int error;

	error = param_set_ulong(val, kp);
	if (error < 0)
		return (SET_ERROR(error));

	if (spa_mode_global != 0) {
		mutex_enter(&spa_namespace_lock);
		while ((spa = spa_next(spa)) != NULL)
			spa->spa_deadman_synctime =
			    MSEC2NSEC(zfs_deadman_synctime_ms);
		mutex_exit(&spa_namespace_lock);
	}

	return (0);
}

int
param_set_slop_shift(const char *buf, zfs_kernel_param_t *kp)
{
	unsigned long val;
	int error;

	error = kstrtoul(buf, 0, &val);
	if (error)
		return (SET_ERROR(error));

	if (val < 1 || val > 31)
		return (SET_ERROR(-EINVAL));

	error = param_set_int(buf, kp);
	if (error < 0)
		return (SET_ERROR(error));

	return (0);
}
