#
# Copyright 2015 ClusterHQ
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from setuptools import setup, find_packages

setup(
    name="pyzfs",
    version="1.0.0",
    description="Wrapper for libzfs_core",
    author="ClusterHQ",
    author_email="support@clusterhq.com",
    url="http://pyzfs.readthedocs.org",
    license="Apache License, Version 2.0",
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: Apache Software License",
        "Programming Language :: Python :: 2 :: Only",
        "Programming Language :: Python :: 2.7",
        "Topic :: System :: Filesystems",
        "Topic :: Software Development :: Libraries",
    ],
    keywords=[
        "ZFS",
        "OpenZFS",
        "libzfs_core",
    ],

    packages=find_packages(),
    include_package_data=True,
    install_requires=[
        "cffi",
    ],
    setup_requires=[
        "cffi",
    ],
    python_requires='>=2.7,<3',
    zip_safe=False,
    test_suite="libzfs_core.test",
)

# vim: softtabstop=4 tabstop=4 expandtab shiftwidth=4
